set more off 
pause off
set logtype text
set mem 500M

tempfile currtemp

*************** DESCRIPTION *************************************
* Loads regulation index and aggregates to current BEA segments.
*
*	Input: 		0.raw_inputs\bds_f_sic_release.csv
*	Output: 	2.intermediate\entry_out
*
*****************************************************************

************************
*** REGULATION INDEX ***
************************

* Note: regulation index not available for all industries available 
* Use changes in index only; indexes not comparable across industries in levels 
import excel 0.raw_inputs\regdata_by_3-digit_industry.xls, firstrow clear
	
rename industry naics
rename Industryrelevantrestr regindex
xtset naics year
g logreg = log(regindex)
keep year naics regindex logreg 
save `currtemp', replace

* Map to BEA codes
import excel 1.user_inputs\NAICS2BEA.xlsx, firstrow clear
merge 1:m naics using `currtemp', keep(matched using) nogen

* Map to BEA segments 
merge m:1 beacode using 6.Temp\levelkey, keep(matched) nogen
g indcode = ind_short  

* Aggregate 
foreach X in regindex logreg{
	egen a1m_`X' = mean(`X'), by(ind_short year)
	egen a1med_`X' = median(`X'), by(ind_short year)
}

bys ind_sh year: keep if _n ==1 
keep ind_short year a1*
g indcode = ind_short

compress
save 2.intermediate\regindex_out, replace

g test = a1m_regindex - 3362.31 if ind_sh == "Agriculture" & year==1970	
su test*
drop test*
